<?php
defined( 'ABSPATH' ) || die( 'Cheatin’ uh?' );

?>
<h1 class="screen-reader-text"><?php esc_html_e( 'Settings', 'imagify' ); ?> — Imagify <?php echo IMAGIFY_VERSION; ?></h1>

<div class="imagify-title">
	<p class="imagify-logo-block">
		<span class="imagify-lb-icon">
			<svg width="38px" height="39px" viewBox="0 0 38 39" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(-30.000000, -33.000000)"><g fill="#40B1D0" fill-rule="nonzero" stroke="#40B1D0"><g transform="translate(31.000000, 28.000000)"><g transform="translate(0.000000, 6.000000)"><path d="M21.54416,37.0285714 L14.458596,37.0285714 C13.6283527,37.0285714 12.9259577,36.4176 12.8258356,35.6076 L12.2158609,31.3493143 C11.382537,30.9728571 10.5753988,30.5038286 9.80830952,29.9499429 L5.79880447,31.5622286 C5.00398903,31.8507429 4.13831794,31.5298286 3.75477328,30.8262857 L0.221233299,24.7026857 C-0.180795443,23.9636571 -0.00827736236,23.0765143 0.621721701,22.5766286 L4.02279244,19.9121143 C3.97196122,19.3906286 3.94577544,18.9385714 3.94577544,18.5142857 C3.94577544,18.09 3.97196122,17.6379429 4.02587312,17.1164571 L0.627883061,14.4565714 C-0.0190597424,13.9443429 -0.190037483,13.0278857 0.227394659,12.3212571 L3.76555566,6.1884 C4.15064066,5.48177143 5.02555379,5.16394286 5.79418345,5.4648 L9.81447088,7.08171429 C10.616988,6.50777143 11.4102631,6.04645714 12.2174013,5.6808 L12.8289163,1.40554286 C12.927498,0.610971429 13.6298931,0 14.4601363,0 L21.5457004,0 C22.3759436,0 23.0783387,0.610971429 23.1784608,1.42097143 L23.7884354,5.6808 C24.6217594,6.05571429 25.4273572,6.52474286 26.1944465,7.08017143 L30.2039516,5.46788571 C30.994146,5.17628571 31.8613574,5.49874286 32.2479828,6.20382857 L35.7815227,12.3274286 C36.1850918,13.0664571 36.0110334,13.9536 35.379494,14.4534857 L31.9784233,17.1164571 C32.0215528,17.5268571 32.0585209,18.0066857 32.0585209,18.5142857 C32.0585209,19.0218857 32.0230931,19.5017143 31.9784233,19.9121143 L35.3764133,22.5735429 C36.0110334,23.0780571 36.1835515,23.9652 35.7907648,24.6872571 L32.2387407,30.8417143 C31.8536557,31.5483429 30.9756619,31.8630857 30.2101129,31.5653143 L26.1898255,29.9484 C25.3873084,30.5223429 24.5940333,30.9836571 23.7868951,31.3493143 L23.1753801,35.6230286 C23.0767984,36.4176 22.3744033,37.0285714 21.54416,37.0285714 Z M9.92383502,28.3006286 C10.0901917,28.3006286 10.2565485,28.3546286 10.3936387,28.4610857 C11.2793342,29.1430286 12.2266433,29.6938286 13.2109206,30.0980571 C13.4635364,30.2014286 13.6422158,30.4313143 13.6822646,30.7028571 L14.3553932,35.4039429 L21.54416,35.4857143 L22.3220317,30.7013143 C22.3605402,30.4297714 22.54076,30.1998857 22.7933758,30.0965143 C23.7391446,29.7092571 24.6618082,29.1708 25.616819,28.4549143 C25.8324666,28.2944571 26.1158892,28.2558857 26.3654243,28.3561714 L30.7754177,30.1304571 L34.4445076,23.9312571 C34.4691531,23.8880571 34.4614514,23.8186286 34.4214025,23.7862286 L30.6876183,20.8609714 C30.4750514,20.6943429 30.3641469,20.4258857 30.3980344,20.1574286 C30.4565673,19.6884 30.5166406,19.1268 30.5166406,18.5142857 C30.5166406,17.9033143 30.4565673,17.3401714 30.3980344,16.8711429 C30.3641469,16.6011429 30.4750514,16.3342286 30.6876183,16.1676 L34.4260235,13.2408 C34.4629917,13.2114857 34.4691531,13.1436 34.4368059,13.0834286 L30.9032659,6.95982857 L26.3669646,8.67394286 C26.1128085,8.77731429 25.8278456,8.7372 25.6106577,8.57057143 C24.7234218,7.88708571 23.7761127,7.33628571 22.7933758,6.9336 C22.54076,6.83022857 22.3620806,6.60034286 22.3220317,6.3288 L21.6504435,1.62617143 L14.4601363,1.54285714 L13.6807243,6.3288 C13.6422158,6.5988 13.4635364,6.82868571 13.2109206,6.9336 C12.2651518,7.32085714 11.3409478,7.85777143 10.3874774,8.5752 C10.1702894,8.7372 9.8884072,8.77577143 9.63733177,8.67394286 L5.22733833,6.89965714 L1.55824843,13.0988571 L5.31513771,16.1676 C5.52770463,16.3342286 5.63860911,16.6011429 5.60472163,16.8711429 C5.52462395,17.5191429 5.48611545,18.0406286 5.48611545,18.5142857 C5.48611545,18.9879429 5.52308361,19.5109714 5.60472163,20.1574286 C5.63860911,20.4258857 5.52770463,20.6943429 5.31513771,20.8609714 L1.57673251,23.7877714 C1.53976435,23.8170857 1.53360299,23.8865143 1.56595013,23.9466857 L5.09949011,30.0702857 L9.63579143,28.3561714 C9.72975217,28.3176 9.8267936,28.3006286 9.92383502,28.3006286 Z M18.001378,26.2285714 C13.7546606,26.2285714 10.299678,22.7679429 10.299678,18.5142857 C10.299678,14.2606286 13.7546606,10.8 18.001378,10.8 C22.2480954,10.8 25.7030781,14.2606286 25.7030781,18.5142857 C25.7030781,22.7679429 22.2480954,26.2285714 18.001378,26.2285714 Z M18.001378,12.3428571 C14.603388,12.3428571 11.840018,15.1107429 11.840018,18.5142857 C11.840018,21.9178286 14.603388,24.6857143 18.001378,24.6857143 C21.3993681,24.6857143 24.1627381,21.9178286 24.1627381,18.5142857 C24.1627381,15.1107429 21.3993681,12.3428571 18.001378,12.3428571 Z"></path></g></g></g></g></svg>
		</span>
		<span class="imagify-lb-text">
			<img width="139" height="16" alt="Imagify" src="<?php echo IMAGIFY_ASSETS_IMG_URL; ?>imagify-logo.png" class="imagify-logo" />
			<?php _e( 'Settings', 'imagify' ); ?>
		</span>
	</p>

	<?php
	if ( Imagify_Options::get_instance()->get( 'api_key' ) ) {
		?>
		<p class="imagify-rate-us">
			<?php
			printf(
				/* translators: 1 is a "bold" tag start, 2 is the "bold" tag end + a line break tag, 3 is a link tag start, 4 is the link tag end. */
				__( '%1$sDo you like this plugin?%2$s Please take a few seconds to %3$srate it on WordPress.org%4$s!', 'imagify' ),
				'<strong>',
				'</strong><br />',
				'<a href="' . esc_url( imagify_get_external_url( 'rate' ) ) . '" target="_blank">',
				'</a>'
			);
			?>
			<br>
			<a class="stars" aria-hidden="true" href="<?php echo esc_url( imagify_get_external_url( 'rate' ) ); ?>" target="_blank"><?php echo str_repeat( '<span class="dashicons dashicons-star-filled"></span>', 5 ); ?></a>
		</p>
		<?php
	}
	?>

	<?php $this->print_template( 'part-documentation-link' ); ?>
</div>
<?php
